class AdvancedUserRecipe1289709253(BasicNewsRecipe):
    title          = u'Ironman Fitness'
    oldest_article = 200
    max_articles_per_feed = 100
    summary_length         = 100
    use_embedded_content  = False
    no_stylesheets = True

    remove_javascript     = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:normal;font-size:small;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''

    remove_tags_after = dict(id='commentblock')
    remove_tags = [dict(name='div', attrs={'class':['postmeta','date','wp-caption alignnone']}),
                   dict(name='div', attrs={'id':['commentblock','header']}),
                   dict(name=['img','h3']),]

    feeds          = [(u'Bodybuiding', u'http://feeds.feedburner.com/JerryBrainum'), 
                          (u'Biomechanics', u'http://feeds.feedburner.com/dougbrignole'), 
                          (u'Diet', u'http://feeds.feedburner.com/IronManMagazineTad'), 
                          (u'Over 40', u'http://feeds.feedburner.com/IronManMagazineDaveGoodin'), 
                          (u'Muscle Building Tips', u'http://feeds.feedburner.com/FastMuscleBuildingTips') ]


    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup